<table style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th
                style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0 ;text-align:left;font-weight: normal;">
                <?php echo app('translator')->get('billable::product.table_heading'); ?>
            </th>
            <th
                style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0; text-align: right;font-weight: normal;">
                <?php echo app('translator')->get('billable::product.qty'); ?>
            </th>
            <th
                style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0; text-align: right;font-weight: normal; white-space: nowrap;">
                <?php echo app('translator')->get('billable::product.unit_price'); ?>
            </th>
            <?php if($billable->isTaxable()): ?>
                <th
                    style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0; text-align: right;font-weight: normal;">
                    <?php echo app('translator')->get('billable::product.tax'); ?>
                </th>
            <?php endif; ?>

            <?php if($billable->hasDiscount()): ?>
                <th
                    style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0; text-align: right;font-weight: normal;">
                    <?php echo app('translator')->get('billable::product.discount'); ?>
                </th>
            <?php endif; ?>
            <th
                style="font-size: 13.5px; padding: 12px; border-bottom: 1px solid #f0f0f0; text-align: right;font-weight: normal;">
                <?php echo app('translator')->get('billable::product.amount'); ?>
            </th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $billable->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td style="border-bottom: 1px solid #f0f0f0; text-align:left; font-weight: bold;">
                    <?php echo e(($product->sku ? $product->sku . ': ' : '') . $product->name); ?>


                    <?php if($product->description): ?>
                        <div style="color: #64748b; font-size: 13.5px; line-height: 13px; font-weight: normal;">
                            <?php echo nl2br(e($product->description)); ?>

                        </div>
                    <?php endif; ?>
                </td>

                <td style="border-bottom: 1px solid #f0f0f0; text-align: right;">
                    <?php echo e($product->qty); ?> <?php echo e($product->unit ?: ''); ?>

                </td>

                <td style="border-bottom: 1px solid #f0f0f0; text-align: right;">
                    <?php echo e($product->unitPrice()->format()); ?>

                </td>

                <?php if($billable->isTaxable()): ?>
                    <td style="border-bottom: 1px solid #f0f0f0; text-align: right;">
                        <?php echo e($product->tax_label); ?> <span
                            style="font-size: 13px; color: #64748b;">(<?php echo e($product->tax_rate); ?>%)</span>
                    </td>
                <?php endif; ?>

                <?php if($billable->hasDiscount()): ?>
                    <td style="border-bottom: 1px solid #f0f0f0; text-align: right;">
                        <?php if($product->discount_type === 'fixed'): ?>
                            <span>
                                <?php echo e($product->discountedAmount()->format()); ?>

                            </span>
                        <?php endif; ?>
                        <?php if($product->discount_type === 'percent'): ?>
                            <span>
                                <?php echo e($product->discount_total); ?>%
                            </span>
                        <?php endif; ?>
                    </td>
                <?php endif; ?>

                <td style="border-bottom: 1px solid #f0f0f0; text-align: right;">
                    <?php echo e($product->amount()->format()); ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    <?php
        $colspans = 3;
        if ($billable->hasDiscount() && $billable->isTaxable()) {
            $colspans = 5;
        } elseif ($billable->hasDiscount() || $billable->isTaxable()) {
            $colspans = 4;
        }

    ?>
    <tfoot>
        <tr>
            <th style="font-size: 14px; text-align: right; font-weight: bold; padding-right: 10px;"
                colspan="<?php echo e($colspans); ?>">
                <?php echo app('translator')->get('billable::billable.sub_total'); ?>

                <?php if($billable->hasDiscount()): ?>
                    <p style="font-style: italic; margin:0; font-weight: normal; font-size: 13px; color: #64748b;">
                        (
                        <?php echo app('translator')->get('billable::billable.includes_discount', [
                            // format
                            'amount' => $billable->discountedAmount()->format(),
                        ]); ?>
                        )
                    </p>
                <?php endif; ?>
            </th>

            <td style="text-align: right; font-size: 14px; white-space: nowrap;">
                <?php echo e($billable->subtotal()->format()); ?>

            </td>
        </tr>
        <?php if($billable->tax_type !== 'no_tax'): ?>
            <?php $__currentLoopData = $billable->taxes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <th style="font-size: 14px; text-align: right; font-weight: bold; padding-right: 10px;"
                        colspan="<?php echo e($colspans); ?>">
                        <?php echo e($tax['label']); ?> (<?php echo e($tax['rate']); ?>%)
                    </th>
                    <td style="text-align: right; font-size: 14px; white-space: nowrap;">
                        <?php if($billable->isTaxInclusive()): ?>
                            <?php echo app('translator')->get('billable::billable.tax_amount_is_inclusive'); ?>
                        <?php endif; ?>
                        <?php echo e($tax['total']->format()); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <tr>
            <th style="font-size: 14px; text-align: right; font-weight: bold; padding-right: 10px;"
                colspan="<?php echo e($colspans); ?>">
                <?php echo app('translator')->get('billable::billable.total'); ?>
            </th>
            <td style="text-align: right; font-size: 14px; white-space: nowrap;">
                <?php echo e($billable->total()->format()); ?>

            </td>
        </tr>
    </tfoot>
</table>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Billable/resources/views/products/table.blade.php ENDPATH**/ ?>