<div class="p-3">

    <h4 class="my-5 text-lg font-semibold text-neutral-800">PHP Version</h4>

    <div class="flex flex-col">
        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                <div class="overflow-hidden border border-neutral-200 shadow-sm sm:rounded-lg">
                    <table class="min-w-full divide-y divide-neutral-200">
                        <thead class="bg-neutral-50">
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Required PHP Version
                            </th>
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Current
                            </th>
                        </thead>
                        <tbody class="divide-y divide-neutral-200 bg-white">
                            <td class="whitespace-nowrap px-4 py-2 text-sm font-medium text-neutral-900">
                                >= <?php echo e($php['minimum']); ?>

                            </td>
                            <td class="whitespace-nowrap px-4 py-2 text-sm text-neutral-900">
                                <span
                                    class="<?php echo e($php['supported'] ? 'text-success-500' : 'text-danger-500'); ?> inline-flex">
                                    <?php if($php['supported']): ?>
                                        <?php echo $__env->make('installer::passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?>
                                    <?php echo e($php['current']); ?>

                                </span>
                            </td>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <h4 class="mb-5 mt-10 text-lg font-semibold text-neutral-800">Required PHP Extensions</h4>

    <div class="flex flex-col">
        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                <div class="overflow-hidden border border-neutral-200 shadow-sm sm:rounded-lg">
                    <table class="min-w-full divide-y divide-neutral-200">
                        <thead class="bg-neutral-50">
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Extension
                            </th>
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Enabled
                            </th>

                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $requirements['results']['php']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm font-medium text-neutral-900">
                                        <?php echo e($requirement); ?>

                                    </td>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm text-neutral-900">
                                        <span
                                            class="<?php echo e($enabled ? 'text-success-500' : 'text-danger-500'); ?> inline-flex">
                                            <?php if($enabled): ?>
                                                <?php echo $__env->make('installer::passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                            <?php echo e($enabled ? 'Yes' : 'No'); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <h4 class="mb-5 mt-10 text-lg font-semibold text-neutral-800">Required PHP Functions</h4>

    <div class="flex flex-col">
        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                <div class="overflow-hidden border border-neutral-200 shadow-sm sm:rounded-lg">
                    <table class="min-w-full divide-y divide-neutral-200">
                        <thead class="bg-neutral-50">
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Function
                            </th>
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Enabled
                            </th>

                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $requirements['results']['functions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $function => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm font-medium text-neutral-900">
                                        <?php echo e($function); ?>

                                    </td>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm text-neutral-900">
                                        <span
                                            class="<?php echo e($enabled ? 'text-success-500' : 'text-danger-500'); ?> inline-flex">
                                            <?php if($enabled): ?>
                                                <?php echo $__env->make('installer::passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                            <?php echo e($enabled ? 'Yes' : 'No'); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <h4 class="mb-5 mt-10 text-lg font-semibold text-neutral-800">Recommended PHP Extensions/Functions</h4>

    <div class="flex flex-col">
        <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
            <div class="inline-block min-w-full py-2 align-middle sm:px-6 lg:px-8">
                <div class="overflow-hidden border border-neutral-200 shadow-sm sm:rounded-lg">
                    <table class="min-w-full divide-y divide-neutral-200">
                        <thead class="bg-neutral-50">
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Requirement
                            </th>
                            <th scope="col"
                                class="px-4 py-3 text-left text-xs font-medium uppercase tracking-wider text-neutral-500">
                                Enabled
                            </th>

                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $requirements['recommended']['php']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm font-medium text-neutral-900">
                                        <?php echo e($requirement); ?> <span class="text-xs text-neutral-400">(ext)</span>
                                    </td>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm text-neutral-900">
                                        <span
                                            class="<?php echo e($enabled ? 'text-success-500' : 'text-warning-500'); ?> inline-flex">
                                            <?php if($enabled): ?>
                                                <?php echo $__env->make('installer::passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                            <?php echo e($enabled ? 'Yes' : 'No'); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $requirements['recommended']['functions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $function => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm font-medium text-neutral-900">
                                        <?php echo e($function); ?> <span class="text-xs text-neutral-400">(func)</span>
                                    </td>
                                    <td class="whitespace-nowrap px-4 py-2 text-sm text-neutral-900">
                                        <span
                                            class="<?php echo e($enabled ? 'text-success-500' : 'text-warning-500'); ?> inline-flex">
                                            <?php if($enabled): ?>
                                                <?php echo $__env->make('installer::passes-icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                            <?php echo e($enabled ? 'Yes' : 'No'); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Installer/resources/views/includes/requirements.blade.php ENDPATH**/ ?>