<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-v="<?php echo e(\Modules\Core\Application::VERSION); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

    <?php echo $__env->renderWhen(config('core.favicon_enabled'), 'favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

    <?php echo $__env->make('core::theme-change', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <script>
        window.Innoclapps = {
            bootingCallbacks: [],
            bootedCallbacks: [],
            booting: function(callback) {
                this.bootingCallbacks.push(callback)
            },
            booted: function(callback) {
                this.bootedCallbacks.push(callback)
            }
        }
    </script>

    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">

    <script src="<?php echo e(\Modules\Core\Facades\Innoclapps::vueSrc()); ?>"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>

    <script>
        updateTheme();

        var config = <?php echo json_encode(\Modules\Core\Application::getDataProvidedToScript(), 15, 512) ?>;
        var lang = <?php echo json_encode(get_generated_lang(app()->getLocale()), 15, 512) ?>;
    </script>

    <!-- Add all of the custom registered styles -->
    <?php $__currentLoopData = \Modules\Core\Facades\Innoclapps::styles(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(\Illuminate\Support\Str::startsWith($path, ['http://', 'https://'])): ?>
            <link rel="stylesheet" href="<?php echo $path; ?>">
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(url("styles/$name")); ?>">
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if ($__env->exists('custom.includes.head')) echo $__env->make('custom.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
</head>

<body>
    <div id="app">
        <div class="flex min-h-screen flex-col justify-center bg-neutral-50 py-12 dark:bg-neutral-900 sm:px-6 lg:px-8">
            <div class="sm:mx-auto sm:w-full sm:max-w-md">
                <?php echo $__env->make('core::brand', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <h2 class="mt-6 text-center text-3xl font-extrabold text-neutral-900 dark:text-neutral-100">
                    <?php echo $__env->yieldContent('title'); ?>
                </h2>
                <p class="mt-1 text-center text-base text-neutral-600 dark:text-neutral-300">
                    <?php echo $__env->yieldContent('subtitle'); ?>
                </p>
            </div>

            <div class="mt-8 px-2 sm:mx-auto sm:w-full sm:max-w-md sm:px-0">
                <div class="rounded-lg bg-white px-6 py-8 shadow dark:bg-neutral-800 sm:px-10">
                    <div class="space-y-4">
                        <?php echo $__env->make('core::warnings.www-url-prefix', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('core::warnings.incorrect-url', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        
                        <div></div>
                    </div>
                    <?php echo e($slot); ?>

                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('core::boot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        bootApplication(config, Innoclapps.bootingCallbacks, Innoclapps.bootedCallbacks);
    </script>
</body>

</html>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Auth/resources/views/components/layouts/auth.blade.php ENDPATH**/ ?>