<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

    <?php echo $__env->renderWhen(config('core.favicon_enabled'), 'favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path'])); ?>

    <?php echo $__env->make('core::theme-change', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title><?php echo e(config('app.name')); ?></title>

    <script>
        window.Innoclapps = {
            bootingCallbacks: [],
            bootedCallbacks: [],
            booting: function(callback) {
                this.bootingCallbacks.push(callback)
            },
            booted: function(callback) {
                this.bootedCallbacks.push(callback)
            }
        }
    </script>

    <link rel="stylesheet" href="https://rsms.me/inter/inter.css">

    <script src="<?php echo e(\Modules\Core\Facades\Innoclapps::vueSrc()); ?>"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js', 'resources/css/contentbuilder/theme.css']); ?>

    <?php echo \Modules\Core\Facades\Innoclapps::viteOutput(); ?>


    <script>
        updateTheme();

        var config = <?php echo json_encode(\Modules\Core\Application::getDataProvidedToScript(), 15, 512) ?>;
        var lang = <?php echo json_encode(get_generated_lang(app()->getLocale()), 15, 512) ?>;
    </script>

    
    <?php $__currentLoopData = \Modules\Core\Facades\Innoclapps::styles(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(\Illuminate\Support\Str::startsWith($path, ['http://', 'https://'])): ?>
            <link rel="stylesheet" href="<?php echo $path; ?>">
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(url("styles/$name")); ?>">
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if ($__env->exists('custom.includes.head')) echo $__env->make('custom.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
</head>

<body>
    <div class="flex h-screen overflow-hidden bg-neutral-100 dark:bg-neutral-800" id="app" v-cloak>
        <the-sidebar></the-sidebar>

        <div class="flex w-0 flex-1 flex-col overflow-hidden">

            <?php echo $__env->make('core::warnings.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <the-navbar></the-navbar>

            

            <?php if($alert = get_current_alert()): ?>
                <i-alert variant="<?php echo e($alert['variant']); ?>" dismissible>
                    <i-alert-body>
                        <?php echo e($alert['message']); ?>

                    </i-alert-body>
                </i-alert>
            <?php endif; ?>

            <?php if(auth()->user()->can('use voip') && config('voip.client') !== null): ?>
                <call-component></call-component>
            <?php endif; ?>

            <router-view></router-view>

            <the-floating-resource-modal></the-floating-resource-modal>

            <teleport
                :to="confirmationDialog.value && confirmationDialog.value._teleport ? confirmationDialog.value._teleport :
                    'body'">
                <i-confirmation-dialog v-if="confirmationDialog.value" :dialog="confirmationDialog.value">
                </i-confirmation-dialog>
            </teleport>

            <teleport to="body">
                <the-float-notifications></the-float-notifications>
            </teleport>
        </div>
    </div>

    <script src="<?php echo e(asset('static/tinymce/tinymce.min.js?v=' . \Modules\Core\Application::VERSION)); ?>"></script>

    
    <?php $__currentLoopData = \Modules\Core\Facades\Innoclapps::scripts(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(\Illuminate\Support\Str::startsWith($path, ['http://', 'https://'])): ?>
            <script src="<?php echo $path; ?>"></script>
        <?php else: ?>
            <script src="<?php echo e(url("scripts/$name")); ?>"></script>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php echo $__env->make('core::boot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        bootApplication(config, Innoclapps.bootingCallbacks, Innoclapps.bootedCallbacks);
    </script>
</body>

</html>
<?php /**PATH /home/theboxwe/pipedrive.theboxwebgt.com/modules/Core/resources/views/app.blade.php ENDPATH**/ ?>